#ifndef GST_ISATIS_HEADER_PARSER_HAPP
#define GST_ISATIS_HEADER_PARSER_HAPP

#include <buildspec.h>

#include <GSTenums.h>
#include <Parsers/GrammarRawStructs.h>
#include <boost/shared_ptr.hpp>
#include <iosfwd>
#include <string>
#include <vector>

namespace GST
{
namespace Parsers
{
class IParsingActions;

namespace IsatisParser
{
struct FieldInfo
{
	std::string type;
	std::string name;
	std::string noDataValue;
	std::string unit;
	std::string f_type;
	std::string description;
	int id;
	int bitlength;
	int f_length;
	int f_digits;
};
struct MetaData
{
	std::vector<FieldInfo> fieldInfos;
	GridDescription gridDescription;
};

void getAnglesFromOrientation(const GridOrientation &orientation,
							  double &theta,
							  double &phi,
							  double &psi);

GST_API_EXPORT
MetaData parseIsatisHeader(const std::string &file);
GST_API_EXPORT
MetaData parseIsatisHeader(std::istream &is);
void GST_API_EXPORT
parseIsatisFile(boost::shared_ptr<GST::Parsers::IParsingActions> p,
				const std::string &content);

GST_API_EXPORT Geometry::PropertyTypes propertyTypeFromFieldInfo(
	const FieldInfo &fieldInfo);

} // namespace IsatisParser
} // namespace Parsers
} // namespace GST

#endif // GST_ISATIS_HEADER_PARSER_HAPP
